<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

 !defined('DL_Root') && exit ( 'Access Denied!' );
 
class DEr extends DuoLamBase{

	private static $_text = "系统视图文件不存在！";

	public static $trace = array();

	public static function error($msg,$db=false,$other = array())
	{
		self::$trace = debug_backtrace();
		$file = DL_Root . 'Views' . DS . 'DSystem'. DS .'error.php';
		is_file($file) or self::notice(self::$_text);
		include_once $file;
		exit;
	}

	public static function notice($msg)
	{
		$file = DL_Root . 'Views' . DS . 'DSystem' . DS . 'notice.php';
		is_file($file) or exit(self::$_text);
		include_once $file;
		exit;
	}
	
	public static function e404($msg=null)
	{
		$url = $_SERVER['HTTP_HOST'].DuoLam::url();
		if(empty(self::$config['frame']['404']))
		{
			$file = DL_Root . 'Views' . DS . 'DSystem'. DS .'404.php';
			is_file($file) or self::notice(self::$_text);
		}
		else
		{
			$file = self::$config['frame']['404'];
			is_file($file) or self::notice('自定义的404文件不存在！');
		}
		include_once $file;
		exit;
	}

	public static function setFile($file,$line)
	{
		if(is_file($file))
		{
			$data = file($file);
			$count = count($data) - 1;
			$startLine = $line - 5;
			$endLine = $line + 5;
			if($endLine > $count)
			{
				$endLine = $count + 1;
			}
			$datas = array();
			for($i = $startLine; $i <= $endLine; $i++)
			{
				if($i == $line)
				{
					$datas[] = '<div class="highcode">&nbsp;<span>' . $i .'</span>　' . self::highCode($data[$i-1],true) . '</div>';
				}
				else
				{
					$datas[] = '&nbsp;' . $i . '　' . self::highCode($data[$i-1],true);
				}
			}
			return $datas;
		}
		else
		{
			return false;
		}
	}

	public static function highCode($code)
	{
		$array1 = array(
			"/&lt;\?php&nbsp;/i",
		);
		$array2 = array(
			'',
		);
		return preg_replace($array1,$array2,highlight_string('<?php ' . $code,true));
	}
}
?>
